#pragma rtGlobals=1		// Use modern global access method.


Menu "Plot&Fit"
	Submenu "Cleanup Tools"	
		"Make dummy error wave",DWS_ReflManipulationPnl()
		"Q x 10", qtimes10()
		 "GetUSAXSParameters",GetUSAXSParameters(2)
		"Change DSM to qrs", DSMtoQRS(1)
		"Change QRS Names/6",FixQRSNames()
		"Change Motofit Names",Change_Motofit_Names()
		"Normalize R and S waves",NormalizeRandSwaves()
		"Absolute Intensity Multiplier/9", AbsIntMultiplierFcn() 
		"Change Folder Names to Spec Comment", SpectoFolderName()
		"Change Irena unified fit to qrs format", FixIlavskyName()
	end
		Submenu "SAS Utilities"
		"Get Polydispersity from Unified intensity with A Cursor",getpolydispersity("1","1")
		"Density of  Suspension",DensityfromWTpct(3,2.85,1)
		"Density from weight and volume", DensityFromWeightInit()
		"Bragg Spacing",BraggSpacing(1)
		"Devidebyconc",DivideByConc()
		"-"
end
	end
	Submenu "Surface Area Utilities"
		"Surface area Calculations",SAcalcs(100,1,1.2,2,100)
	end
end

Function Change_Motofit_Names()
	string df, list
string startDF ="Root:data:"
	setdatafolder Root:data:
	list= datafolderdir(1)
	list=list[20,3000]
		list=ReplaceString(",", list, ";"  )
		Prompt df, "Select Folder", popup, list
		DoPrompt "folder selection",df
		if (V_Flag)
			Abort 
		endif	
		setdatafolder df

FixNames_Motofit()
end

function FixNames_Motofit()
	string name="",fullfoldername,rwavename,foldername
	foldername=getdatafolder(0)
	name=cleanupName(ReplaceString("'", foldername, ""),1)
	name =CleanupName(Getnamechanges(name), 0 )
	IF (stringmatch(name, ""))
		Return 0
	endif
	string Ra,Qa,Sa,Ea,Wa,oldRa,oldQa,oldSa,oldEa,oldWa,coef,fitr,fitq,res,sld,oldcoef,oldfitr,oldfitq,oldres,oldsld
	if (!stringmatch(name, foldername ))
		fullfoldername="::"+foldername
		RenameDataFolder $fullfoldername,$name
	endif

		Ra=name+"_R"
		Qa=name+"_q"
		Sa=name+"_E"
		Wa=name+"_dq"
		coef="coef_"+Ra
		fitR="fit_"+Ra
		res="res_"+Ra
		fitq="fit_"+Qa
		sld="SLD_"+Ra

		foldername =ReplaceString("'", foldername, "")//takes out ' for liberal names
		
		oldRa=foldername+"_R"
		oldQa=foldername+"_q"
		oldSa=foldername+"_E"
		oldWa=foldername+"_dq"
		oldcoef="coef_"+oldRa
		oldfitR="fit_"+oldRa
		oldres="res_"+oldRa
		oldfitq="fit_"+oldQa
		oldsld="SLD_"+oldRa

			rename $oldRa,$Ra
			rename $oldQa,$Qa
			rename $oldSa,$Sa
			rename $oldWa,$Wa
			wave/z w=$oldcoef
			if (waveexists(w))
			rename w, $coef
			endif
			wave/z w=$oldFitR
			if (waveexists(w))
			rename w, $FitR
			endif
			wave/z w=$oldres
			if (waveexists(w))
			rename w, $res
			endif
			wave/z w=$oldfitq
			if (waveexists(w))
			rename w, $fitq
			endif			
			wave/z w=$oldSLD
			if (waveexists(w))
			rename w, $SLD
			endif
end

Function NormalizeRandSwaves()
	string Samplefolder, foldername
	Prompt SampleFolder, "Select  data folder for sample", popup, FindQRSfolders()
	doprompt "Input Panel", SampleFolder	
	SetDataFolder SampleFolder		
	foldername=getdatafolder(0)
	string name= foldername[1,100]
	string Rwvname,Swvname
	Rwvname="r"+name
	Swvname="s"+name
	wave/z Rwv=$Rwvname
	wave/z Swv=$Swvname
	variable factor=1
	if (!exists("NormalizationDivisor"))		
			variable/g  NormalizationDivisor=1
		endif
	NVAR NormalizationDivisor
	factor=NormalizationDivisor
	Prompt factor, "Enter new divisorr . Enter 1 to get original wave"
	doprompt "Divide by",factor
	print (factor/NormalizationDivisor)
	Swv/=(factor/NormalizationDivisor)
	Rwv/=(factor/NormalizationDivisor)
	NormalizationDivisor=Factor
end	

Function AbsIntMultiplierFcn()
	string Samplefolder, foldername
	Prompt SampleFolder, "Select  data folder for sample", popup, FindQRSfolders()
	doprompt "Input Panel", SampleFolder	
	SetDataFolder SampleFolder		
	foldername=getdatafolder(0)
	string name= foldername[1,100]
	string Rwvname,Swvname,newRwvname,newSwvname
	Rwvname="r"+name
	Swvname="s"+name
	newRwvname=Rwvname;newSwvname=Swvname
	wave/z Rwv=$Rwvname;wave/z Swv=$Swvname
	
	
	variable factor=1
	//if (!exists("AbsIntMultiplier"))		
		//	variable/g  AbsIntMultiplier=1//6mm = 21.1  4mm = 49.1
		//endif
	//NVAR AbsIntMultiplier
	//factor=AbsIntMultiplier
	Prompt factor, "Enter new multplier. \rEnter 1 to get original wave\r rwave only"
	doprompt "multiply by",factor
	newRwvname=newRwvname+"x"+num2str(factor)
	Duplicate Rwv,$newRwvname//,$newSwvname
	wave newRwv=$newRwvname
	//print (factor*AbsIntMultiplier)
	//Swv*=factor*AbsIntMultiplier);abortonRTE
	newRwv*=factor//*AbsIntMultiplier
	//AbsIntMultiplier =Factor
end	

Function getpolydispersity(levelR,LevelD)//See C. M. Sorensen, Aerosol Science and Technology,35:648(2001) Fig. 28
	string levelR,LevelD 
		Doalert 0, "Put the cursor on a UnifiedFitIntensity_X wave.\r\rDoes not work with unified fit panel."
	Prompt LevelR,"Enter Structural Level for R:",Popup,"1;2;3;4;5"
	Prompt LevelD,"Enter Structural Level for D:",Popup,"1;2;3;4;5"
	doprompt "input Panel", LevelR,LevelD
	variable ,R,G,D,B
	String tracename,rwavename,innote
	tracename=FindCursorTrace()
	rwavename=FindPath2CursorWave()
	string wavenote= note($rwavename )
	string Rval="Level"+levelR+"Rg",Pval="Level"+levelD+"P",Bval="Level"+levelD+"B",Gval="Level"+levelR+"G"
	R=NumberByKey(Rval, wavenote ,"=");D=NumberByKey(Pval, wavenote ,"=");B=NumberByKey(Bval, wavenote ,"=");G=NumberByKey(Gval, wavenote ,"=")
	string name=stringByKey("DataFolderName", wavenote ,"=")
	name= ParseFilePath(0, name, ":", 1, 0)
	name=name[1,50]	
	if (D>=3)
		//doalert 0, "Doesn't work for D>=3 and !=4"
		
		//S(q>>R)=CCp (qR)^-2=B
		string Dispersity= num2str((B/(1.81*G))*(R^D))
		///PDI=B*Rg^4/(1.62*G),sig_G=exp((ln(PDI)/12)^.5)  beaucage formula via kohls
	elseif (D<3)
		Dispersity = num2str((B/G)*(R^D))//= Cp in eq 57   see page 676
	endif	
	R*=.0001//convert to microns
	name=ReplaceString("'", name, "" )
	Dispersity =name+"\rRg = " +num2str(R)+" m\rPolydispersity = "+Dispersity+"\rD = " +num2str(D)
	string 	text =CleanupName(name, 0)
	Text =UniqueName("T"+text[0,10], 14, 0 )

	Tag/C/N=$text $tracename, pcsr(A),Dispersity
endmacro

Function/T DWS_ReturnListQRSFolders(ListOfQFolders)
	string ListOfQFolders
	
	string result, tempStringQ, tempStringR, tempStringS, nowFolder,oldDf
	oldDf=GetDataFolder(1)
	variable i, j
	result=""
	For(i=0;i<ItemsInList(ListOfQFolders);i+=1)
		NowFolder= stringFromList(i,ListOfQFolders)
		setDataFolder NowFolder
		tempStringQ=DWS_ListOfWavesOfType("q",DWS_ConvertDataDirToList(DataFolderDir(2)))
		tempStringR=DWS_ListOfWavesOfType("r",DWS_ConvertDataDirToList(DataFolderDir(2)))
		tempStringS=DWS_ListOfWavesOfType("s",DWS_ConvertDataDirToList(DataFolderDir(2)))
		For (j=0;j<ItemsInList(tempStringQ);j+=1)
			if (stringMatch(tempStringR,"*r"+StringFromList(j,tempStringQ)[1,inf]+";*") && stringMatch(tempStringS,"*s"+StringFromList(j,tempStringQ)[1,inf]+";*"))
				result+=NowFolder+";"
				break
			endif
		endfor
				
	endfor
	setDataFOlder oldDf
	return result
end

Function/T DWS_ListOfWavesOfType(type,ListOfWaves)
		string type, ListOfWaves
		
		variable i
		string tempresult=""
		for (i=0;i<ItemsInList(ListOfWaves);i+=1)
			if (stringMatch(StringFromList(i,ListOfWaves),type+"*"))
				tempresult+=StringFromList(i,ListOfWaves)+";"
			endif
		endfor

	return tempresult
end

Function/T DWS_ConvertDataDirToList(Str)		//converts   FOLDERS:spec1,spec2,spec3,spec4; type fo strring into list
	string str
	
	str=RemoveListItem(0, Str , ":")					//remove the "FOLDERS"
	variable i=0, imax=itemsInList(str,",")			//working parameters
	string strList="", tmpstr						//working parameters
	str=str[0,strlen(str)-3]						//remove  /r; at the end
	if(stringmatch(str,"*spec*"))					//here we have list of spec scans
		for(i=0;i<imax;i+=1)
			tmpstr=StringFromList(i, str, ",")							
			strList+=tmpstr[4,inf] +";"		
		endfor
		strList=SortList(strList,";",2)
		str=""
		for(i=0;i<imax;i+=1)							
			str+="spec"+StringFromList(i, strList, ";")+";"		
		endfor						
		strList=str				
 	else
		for(i=0;i<imax;i+=1)							
			strList+=StringFromList(i, str, ",")+";"		
		endfor 	
 	endif
 					
	return strList
end

Function/T DWS_CreateListOfItemsInFolder(df,item)			//Generates list of items in given folder
	String df
	variable item										//1-directories, 2-waves, 4 - variables, 8- strings
	
	String dfSave
	dfSave=GetDataFolder(1)
	string MyList=""
	
	if (DataFolderExists(df))
		SetDataFolder $df
		MyList= DWS_ConvertDataDirToList(DataFolderDir(item))	//here we convert the WAVES:wave1;wave2;wave3 into list
		SetDataFolder $dfSave
	else
		MyList=""
	endif
	return MyList
end



//Function/T DWS_ListOfWaves(WaveTp)
	string WaveTp
	
	string result, tempresult, dataType, tempStringQ, tempStringR, tempStringS, tempStringI
	SVAR FldrNm=Root:Packages:SAS_Modeling:DataFolderName
	NVAR iWavesOnly=Root:Packages:GeneralplottingTool:iWavesOnly
	NVAR QRSdata=Root:Packages:GeneralplottingTool:UseQRSData
	NVAR Indra2Dta=Root:Packages:GeneralplottingTool:UseIndra2Data
	variable i,j
		
	if (cmpstr(WaveTp,"DSM")==0)
		result=DWS_CreateListOfItemsInFolder(FldrNm,2)
		if(stringMatch(result,"*"+WaveTp+"*"))
			tempresult=""
			for (i=0;i<ItemsInList(result);i+=1)
				if (stringMatch(StringFromList(i,result),"*"+WaveTp+"*"))
					tempresult+=StringFromList(i,result)+";"
				endif
			endfor
			result=tempresult
		endif
	elseif (strsearch(WaveTp, "QRS", 0 )!=-1)
		result=""			//DWS_CreateListOfItemsInFolder(FldrNm,2)
		tempStringQ=DWS_ListOfWavesOfType("q",DWS_CreateListOfItemsInFolder(FldrNm,2))
		tempStringR=DWS_ListOfWavesOfType("r",DWS_CreateListOfItemsInFolder(FldrNm,2))
		tempStringS=DWS_ListOfWavesOfType("s",DWS_CreateListOfItemsInFolder(FldrNm,2))
		
		if (cmpstr(WaveTp,"QRS_Int")==0)
//			dataType="r"
			For (j=0;j<ItemsInList(tempStringR);j+=1)
				if (stringMatch(tempStringQ,"*q"+StringFromList(j,tempStringR)[1,inf]+";*") && stringMatch(tempStringS,"*s"+StringFromList(j,tempStringR)[1,inf]+";*"))
					result+=StringFromList(j,tempStringR)+";"
				endif
			endfor
		elseif(cmpstr(WaveTp,"QRS_Qvec")==0)
//			dataType="q"
			For (j=0;j<ItemsInList(tempStringQ);j+=1)
				if (stringMatch(tempStringR,"*r"+StringFromList(j,tempStringQ)[1,inf]+";*") && stringMatch(tempStringS,"*s"+StringFromList(j,tempStringQ)[1,inf]+";*"))
					result+=StringFromList(j,tempStringQ)+";"
				endif
			endfor
		else
//			dataType="s"			
			For (j=0;j<ItemsInList(tempStringS);j+=1)
				if (stringMatch(tempStringR,"*r"+StringFromList(j,tempStringS)[1,inf]+";*") && stringMatch(tempStringQ,"*q"+StringFromList(j,tempStringS)[1,inf]+";*"))
					result+=StringFromList(j,tempStringS)+";"
				endif
			endfor
		endif	
	else
		if(cmpstr(WaveTp,"iWaves")==0)
			result=DWS_CreateListOfItemsInFolder(FldrNm,2)
				if(stringMatch(result,"i*"))
				tempresult=""
					for (i=0;i<ItemsInList(result);i+=1)
						if (stringMatch(StringFromList(i,result),"i*"))
							tempresult+=StringFromList(i,result)+";"
						endif
					endfor
				result=tempresult
				endif
		else
		result=DWS_CreateListOfItemsInFolder(FldrNm,2)
		endif
	endif
	
	return result
end

function SAcalcs(r0,density, skldensity,type,SA)
	variable r0, skldensity,type,SA,density
	Prompt type, "Pick Type of Calculation", popup "SA from Particle hard R;Guinier Radius from SA;Chords from Guinier Radius"
	prompt r0, "Radius (hard) in A"
	prompt skldensity, "Skeletal Density in g/cm3"
	prompt density, "Sample Density in g/cm3"
	prompt SA, "Surface Area in m2/g"
	doprompt "What Type of Calculation", Type

	switch(Type)	
		case 1:		
			doprompt "SA Panel", r0,skldensity
			Print "R = "+num2str(r0) +" "
			r0=r0*(3/5)^.5//calcs Rg
			SA=(3e4)/((r0*(5/3)^.5)*skldensity)
			print "SA = "+num2str(SA)+" m2/g"
			print "Rg = "+num2str(r0)+" "
			break					
		case 2:		
			variable ds,phi
			doprompt "Solid Chord Panel",density, skldensity, SA
			phi=density/skldensity
			ds=(4/(skldensity*SA))*1e4//solid chord
			variable a=(1-phi)*ds
			variable DABguinier=sqrt(6)*a
			//Debye Anderson and Brumberger Model  A. M. Fernandez, G. D. Wignal and L. H. Sperling, ACS Adv. Chem Series Vol 211 Page 153-170
			print "Solid Chord (Debye Correlation Range) = "+num2str(a)+" "
			Print "Debye Guinier Radius, sqrt(6)a ="+num2str(DABguinier)+" \r"
			//Independent partilce model
			Print "Particle Guinier Radius = "+num2str(ds*sqrt(27/80))
			Print "Particle Hard Radius = "+num2str(ds*sqrt(9/16))//R0 = 3/(Sm rhos)
		case 3:
			doprompt "SA Panel", r0,skldensity,density
			phi=density/skldensity
			a=r0/sqrt(6)
			print "Solid Chord (Debye Correlation Range) = "+num2str(a/(1-phi))+" "
				print "Pre Chord (Debye Correlation Range) = "+num2str(a/phi)+" "
			break						
		endswitch
end

function DivideByConc()//works on all traces.  conc must exist.  folder and wave names must be matched
	variable N=0, total
	DoAlert 0,"works on all traces.  conc must exist.  folder and wave names must be matched\ryou must define conc in the same folder as the wave"
	abort
	string list,foldername,wname,newwave,qname,sname,news
	list=TraceNameList("",";",1)
	total=ItemsInList(list)
	do
		wname =StringFromList(N, list)
		foldername =getwavesDataFolder(TraceNameToWaveRef("", wname),1)
		setdatafolder getwavesDataFolder(TraceNameToWaveRef("", wname),3)
		wave w=$wname
		qname="q"+wname[1,100]
		sname="s"+wname[1,100]
		newwave=wname+"_oc"
		wave q =$qname//qwave may not exist
		wave s=$sname//not corrected 
		NVAR c=conc//you must define conc in the same folder as the wave
		nvar t=translaser
		print wname+  "    "+num2str(c)
		duplicate/O w,$newwave
		wave wnew=$newwave
		wnew=w/c
		RemoveFromGraph $wname
		AppendToGraph wnew vs q
		N=N+1
		while (N<total)
		Label left "\\F'arial'\\Z18Intensity/c"
end

function BraggSpacing(qvalue)
	variable qvalue
	Prompt qvalue, "enter qvalue"
	doprompt "Enter qPeak", qvalue
	Doalert 0, "d = "+num2str(2*pi/qvalue)
	print num2str(2*pi/qvalue)
end



Function  DensityFromWeightInit()	
	setdatafolder  Root:Packages:P
	variable/g useinches=1, length, width, thickness,weight,density
	execute ("DensityFromWeightPanel()")
end
	

window DensityFromWeightPanel()	
	dowindow/K DensityPanel
	NewPanel /K=1/N=DensityPanel /W=(50,50,300, 300) as "Density from Volume and Weight"
	SetDrawLayer UserBack
	SetDrawEnv fname= "Times New Roman",fsize= 18,fstyle= 3,textrgb= (0,0,52224)
	DrawText 50,20,"Density Calculater"
	SetDrawEnv fname= "Times New Roman",fsize= 18,fstyle= 3,textrgb= (52224,0,0)
	
	DrawText 50,40,"Use g and cm or in"
	SetDrawEnv linethick= 3,linefgc= (0,0,52224)
	DrawLine 16,60,200,60

	
	CheckBox Useinches,pos={10,70},size={100,14},title="Use Inches?",proc=DensityCheckBox,value=1
	
	SetVariable Length pos={10,90},size={120,20},proc=DWS_SetVarProc,title="Length : "
	SetVariable  Length, value= Root:Packages:P:Length,proc= DensitySetVariable
	SetVariable Width pos={10,110},size={120,20},proc=DWS_SetVarProc,title="Width: "
	SetVariable  Width, value= Root:Packages:P:Width,proc= DensitySetVariable
	SetVariable thickness pos={10,130},size={120,20},proc=DWS_SetVarProc,title="Thickness: "
	SetVariable  thickness, value= Root:Packages:P:thickness,proc= DensitySetVariable
	SetVariable Weight pos={10,160},size={120,20},proc=DWS_SetVarProc,title="Weight: "
	SetVariable  Weight, value=Root:Packages:P:weight,proc= DensitySetVariable
	
	Button CalcDensity,pos={10,190},size={80,20},font="Times New Roman",fSize=10,proc=DensityCalc,title="Calc Density"
	ValDisplay Densityval,pos={10 ,220},size={120,16},title="Density = "
	ValDisplay DensityVal,value=Root:Packages:P:density,format="%.3g"
	
End

function DensitySetVariable(ctrlName,varNum,varStr,varName)
	String ctrlName
	Variable varNum
	String varStr
	String varName
	CalcTheDensity()
end

Function DensityCalc(ctrlName) : ButtonControl
	String ctrlName
	CalcTheDensity()
End

Function CalcTheDensity()
	NVAR density=Root:Packages:P:density;NVAR  length=Root:Packages:P:Length;NVAR  weight=Root:Packages:P:weight;NVAR Width=Root:Packages:P:Width;NVAR Thickness=Root:Packages:P:Thickness;NVAR Useinches=Root:Packages:P:useinches
	density=Weight/(length*width*thickness)
	If (useinches==1)
		density=density/(2.54^3)
 	endif
 end

function Denstiy_SetVarProc(ctrlName,varNum,varStr,varName)
	String ctrlName
	Variable varNum
	String varStr
	String varName
end

Function DensityCheckBox(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
	NVAR 	Useinches=Root:Packages:P:useinches
	Useinches=checked
end

	
function DensityfromWTpct(Pct,skl,matrix)
	Variable Pct,skl,matrix
	variable phi
	Prompt Pct,"Weight Percent Minority Phase (Silica)"
	Prompt skl, "Skelital Density of Minority Phase"
	Prompt matrix, "Skelital Density of Matrix Phase"
	DoPrompt "Ask for weight percent", Pct,skl,matrix
	
	variable density
	density =100/(((Pct)/skl)+(100-Pct)/matrix)
	phi=(pct/skl)/((pct/skl)+(100-pct)/matrix)
	doalert 0, "Density of sample = "+num2str(density)+"\rVolume fraction minority = "+num2str(phi)
	return Density
end
	

Macro SAfromDist(density,type)
	Variable density, type
	density=2; type=1
	Prompt density "Skelital Density (g/cm3)"
	Prompt type, "Pick Distribution to use", popup "Volume;Number"
	
	string Xa="Distdiameters",Ya="TotalNumberDist",Yv="TotalVolumeDist"
	setdatafolder   Root:Packages:SAS_Modeling:
	variable Bkg=w_coef[0],Volfract=w_coef[1],scale =w_coef[3], loc=w_coef[2]
	//wave $ya
	duplicate/o$Ya areawave,volumewave,Rwave,V
	string thewave=IntensityWaveName
	//V=(4*pi/3)*($Xa/2)^3
	if (type==2)
		areawave=$Ya*4*pi*($Xa/2)^2
		volumewave=$Ya*(4/3)*pi*($Xa/2)^3
	else
		areawave=$Yv*4*pi*($Xa/2)^2
		volumewave=$Yv*(4/3)*pi*($Xa/2)^3
	endif
	variable SA,Dmax,Rmean,Rsa
	//Dmax=$Xa[numpnts($Xa)]
		SA=areaXY( $Xa,areawave, 0,inf )/areaXY($Xa,volumewave, 0, inf)
	SA =SA*1e4//m2/cm3
	Rwave=$Yv*($Xa/2)
	Rmean= areaXY($Xa,Rwave, 0,inf )/areaXY($Xa,$Yv, 0, inf)

	display $Yv vs $Xa
	Modify grid=2,tick=2,minor=1,font="Times",zero(left)=1,standoff=0, mirror=1;DelayUpdate
	
	Label bottom "\Z14\F'Arial Black'Hard Diameter ()";DelayUpdate
	Label left "\Z14\F'Arial Black'Volume Distribution";DelayUpdate
	SA=SA/density
	string  text=thewave+"\rSurface Area =" +num2str(SA)+" m2/g"
	
	Rsa=3/(1e-4*SA*density)
	text+="\rR = (3/Sv) = "+num2str(Rsa)+" "
	text+="\rlocation = "+num2str(loc)+"\rscale = "+num2str(scale)+"\rRmean = "+num2str(Rmean)
	text+="\rphi = "+num2str(VolFract)+"\rskeldens = "+num2str(density)
	TextBox/C/N=text1/A=LB text
	ChangetoLineandPoints(1,1)
	ModifyGraph mode=3
	killwaves areawave, volumewave,Rwave
endmacro

function GetParameter(message,parameterval)
	string message	
	variable parameterval
	prompt parameterval, "enter "+message	
	//NVAR P=Root:Packages:SAS_Modeling:GenericParameter
	//Parameter=P
	doprompt "parameter",parameterval
	//P=parameter
	return parameterval
end

function/s Getnamechanges(name)
	string name
	Prompt name,"Check new name"
	doprompt "Enter New Name",name
	If (V_flag)
		abort
	endif
	return name
Endmacro

function/s AskName(oldname,name,maxlen)
	string oldname,name
	variable maxlen
	name =CleanupName(oldname,0)
	Prompt name, oldname	
	DoPrompt "Enter a new name", name
	
	if(strlen(name)>maxlen)
		doalert 1, "Sample name > "+num2str(maxlen)+" characters\rTruncate?"
		if (v_flag==1)
			name=name[0,maxlen-1]
		else
			name=AskName(name,name,maxlen)
		endif
	endif
//	print name
	return name
end

function/s getfilename(fullpath) //splits full path into path and filename
	string fullpath
	
	string sdf
	sdf = GetDataFolder(1)	
	SetDataFolder Root:Packages:P//; Variable/G gGlobalRootVar
	string/g gfilename,gpath,gfullpath
	variable counter=0,pos1=0,pos2=0
	do
		pos1=pos2+1
		pos2=strsearch(fullpath,":",pos1)
	while(pos2!=-1) 
	gfilename=(fullpath[(pos1),1000])
	gpath=fullpath[0,pos1-1]
	SetDataFolder sdf
	return gfilename
end


Function/s DWS_UnifiedCalcOne(level,qvec, qcutoff)//qcutoff is zero for no cutoff
	variable level,qcutoff
	string qvec
	
	Duplicate/O $qvec, rUnified,QstarVector
	NVAR Rg=$("Root:Packages:SAS_Modeling:Level"+num2str(level)+"Rg")
	NVAR G=$("Root:Packages:SAS_Modeling:Level"+num2str(level)+"G")
	NVAR P=$("Root:Packages:SAS_Modeling:Level"+num2str(level)+"P")
	NVAR B=$("Root:Packages:SAS_Modeling:Level"+num2str(level)+"B")
	NVAR ETA=$("Root:Packages:SAS_Modeling:Level"+num2str(level)+"ETA")
	NVAR PACK=$("Root:Packages:SAS_Modeling:Level"+num2str(level)+"PACK")
	NVAR RgCO=$("Root:Packages:SAS_Modeling:Level"+num2str(level)+"RgCO")
	NVAR K=$("Root:Packages:SAS_Modeling:Level"+num2str(level)+"K")
	NVAR Corelations=$("Root:Packages:SAS_Modeling:Level"+num2str(level)+"Corelations")
	NVAR MassFractal=$("Root:Packages:SAS_Modeling:Level"+num2str(level)+"MassFractal")
	NVAR LinkRGCO=$("Root:Packages:SAS_Modeling:Level"+num2str(level)+"LinkRGCO")
	if (LinkRGCO==1 && level>=2)
		NVAR RgLowerLevel=$("Root:Packages:SAS_Modeling:Level"+num2str(level-1)+"Rg")	
		RGCO=RgLowerLevel
	endif
	if(qcutoff==0)//added by dws
		RgCO=0
		LinkRgCO =0
		Pack = 0
	endif
	wave qwave=$qvec
	QstarVector=qwave/(erf(K*qwave*Rg/sqrt(6)))^3
	if (MassFractal)
		B=(G*P/Rg^P)*exp(gammln(P/2))
	endif
	
	rUnified=G*exp(-qwave^2*Rg^2/3)+(B/QstarVector^P) * exp(-RGCO^2 * qwave^2/3)
	
	if (Corelations)
		rUnified/=(1+pack*IR1A_SphereAmplitude(qwave,ETA))
	endif
	killwaves qstarvector
	string name="rUnified"
	return name
end

function DWS_UnifiedCalcAll(NumberOfLevels)//also plots//uses current unified values
	variable numberofLevels
	String wavenam="wvnm"
	variable maxq=.2,logs=1,pnts=100,minq=.0001
	prompt wavenam,"Enter wavename"
	Prompt minq,"Min q"
	prompt maxq, "Max q"
	prompt logs, "Log spacing?"
	prompt pnts, "Number of points"
	doprompt "Input Panel", wavenam,minq,maxq,logs,pnts
	make/o/n=(pnts) inwvnm
	inwvnm=minq+((maxQ-minq)/(pnts-1))*p
	If (logs==1)
		logspacing(inwvnm)
	endif
	string outqwvnm="q"+wavenam
	string outrwvnm="r"+wavenam
	duplicate/o inwvnm,$outqwvnm,$outrwvnm,tempunifiedintensity
	wave w=$outrwvnm
	wave q=$outqwvnm
	wave tempunifiedintensity
	w=0
	//NVAR Numberoflevels=Root:Packages:SAS_Modeling:NumberOfLevels	
	variable i
			for(i=1;i<=NumberOfLevels;i+=1)	// initialize variables;continue test
				DWS_UnifiedCalcIntOne($outqwvnm,i,1)//qcutoff is zero for no cutoff
				 w=w+tempunifiedIntensity
			endfor	
		killwaves/z inwvnm,tempunifiedIntensity
		if(cmpstr(WinList("*",";","WIN:1"), "" )==0)
		 	display/n=loglogplot/K=1/W=(400,0,700,350 ) rwave vs qwave
		 	ModifyGraph log=1;DelayUpdate
			Label left "\\Z16Intensity (cm\\S-1\\M\\Z16)";DelayUpdate
			Label bottom "\\Z16q(A\S-1\M\Z16)"
			Legend/C/N=legend1/A=MC
			ModifyGraph margin(bottom)=50
		 else
			AppendToGraph w vs q
		endif
end

Function DWS_UnifiedCalcIntOne(qvec,level,qcutoff)//qcutoff is zero for no cutoff
	variable level,qcutoff
	wave qvec
	
	//setDataFolder Root:Packages:SAS_Modeling
	Duplicate/O qvec, TempUnifiedIntensity, QstarVector
	Redimension/D TempUnifiedIntensity, QstarVector
	
	NVAR Rg=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"Rg")
	NVAR G=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"G")
	NVAR P=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"P")
	NVAR B=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"B")
	NVAR ETA=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"ETA")
	NVAR PACK=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"PACK")
	NVAR RgCO=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"RgCO")
	NVAR K=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"K")
	NVAR Corelations=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"Corelations")
	NVAR MassFractal=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"MassFractal")
	NVAR LinkRGCO=$("Root:Packages:Irena_UnifFit:Level"+num2str(level)+"LinkRGCO")
	variable RgCOold=RgCO
	if(qcutoff==0)//added by dws  zero means no cuttoff
		RgCO=0
		LinkRgCO =0

	endif
	
	QstarVector=qvec/(erf(K*qvec*Rg/sqrt(6)))^3
	if (MassFractal)
		B=(G*P/Rg^P)*exp(gammln(P/2))
	endif
	
	TempUnifiedIntensity=G*exp(-qvec^2*Rg^2/3)+(B/QstarVector^P) * exp(-RGCO^2 * qvec^2/3)
	
	if (Corelations)
		TempUnifiedIntensity/=(1+pack*IR1A_SphereAmplitude(qvec,ETA))
	endif
	RgCO=RgCOold
	killwaves  Qstarvector
end



Function SpectoFolderName()
	variable count=0,tot,results
	String NextFolder

 	print ((CountObjects("root:USAXS:", 4 )))
 	tot=CountObjects("root:USAXS:", 4 )

 	do
 		NextFolder=PossiblyQuoteName(GetIndexedObjName("Root:USAXS:", 4, count))
 		NextFolder ="Root:USAXS:"+NextFolder
 		print Nextfolder
 		setdatafolder nextFolder
 		print getdatafolder(0)
 		results =ScanAllFolders(NextFolder, 2,"ChangeFoldertoSpecComment()")
	 	count=count+1
	 	
	 While(count<=tot)
 	
end


function ChangeFoldertoSpecComment()
	string new="",fullfoldername
	string foldername=getdatafolder (0)
	foldername =CleanupName(foldername, 0 )//same as correctbasename
	new=Getnamechanges(foldername)//user change name
	
	new =CleanupName(new, 0 )
	string name=new
	IF (stringmatch(name, ""))
		Return 0
		abort
	endif
	string Ra, oldRa
	if (!stringmatch(name, foldername ))
		fullfoldername="::"+foldername
		print foldername
		//RenameDataFolder $fullfoldername,$new
	endif
	
end

function FixAnisonamesAPS_local()
	string new="",fullfoldername
	string foldername=getdatafolder (0)
	foldername =CleanupName(foldername, 0 )//same as correctbasename
	new=Getnamechanges(foldername)//user change name
	new =CleanupName(new, 0 )
	string name=new
	IF (stringmatch(name, ""))
		Return 0
	endif
	string Ra, oldRa
	if (!stringmatch(name, foldername ))
		fullfoldername="::"+foldername
		print foldername
		RenameDataFolder $fullfoldername,$new
	endif
	wave/Z AnisoIntensityCorr//debugger fails if wave doesn't exist and /z is missing
	if (waveexists( AnisoIntensityCorr))//does anisowave exixt?
		Ra="a"+name[1,31]//new name
		oldRa= "AnisoIntensityCorr"//old name
		wave/z w=$oldRa
			
	
		string list=WaveList("!*a*", ";", "")
		print list
		variable items=itemsinlist(list,";")
		print num2str(items)
		variable i
		for(i=0;(i<items);i=i+1)	
			//print stringfromlist (i,list)
			killwaves $(stringfromlist (i,list))							
		endfor	
		killwaves 	ay,asrp,pd_rate,pd_range,ar_enc,USAXS_PD,radians
		rename $oldRa,$Ra
	endif	
	return 2
end


function DSMtoQRS(all)
	variable all
	Prompt all, "Change all DSM and M_DSM waves in sub folders?", popup, "Yes;No"
	string df,parentdf
	setdatafolder root:
		Prompt df, "Select Folder", popup, DWS_FindFolderWithWaveTypes("root:", 5, "*DSM_*", 1)	//root:USAXS
		DoPrompt "folder selection",all,df
		if (V_Flag)
			Abort 
		endif	
		SetDataFolder df		
		Parentdf=getdatafolder(0);ParentDF=replacestring(ParentDF,DF,"");ParentDF=replacestring("::",ParentDF,"")
		parentDF+=":"
		
		If (All==2)	//fix one
				//FixNamesAPS()//based on trace     //FixAnisonamesAPS_local()
			FixNamesAPS_local()
		 	DSMtoQRS(2)
		else//do all DSM or M_DSM folders
			print ParentDF
	 		string dflist=DWS_FindFolderWithWaveTypes(ParentDF, 2, "*DSM_*", 1)	
			variable Ntot=itemsinlist(dflist)
			variable N=0
			do
				Df=StringFromList(N, dflist)
				SetDataFolder df		
				FixNamesAPS_local()	
				N+=1		
				print Df	
			while (N<=Ntot)	
		endif		
		setdatafolder root:
end

function FixNamesAPS_local()
	string name="",fullfoldername,rwavename,foldername
	SVAR basename
	foldername=getdatafolder(0)
	name=ReplaceString("'", foldername, "")//name=cleanupName(ReplaceString("'", foldername, ""),1)
	name =Getnamechanges(name)//=CleanupName(Getnamechanges(name), 0 )
	IF (stringmatch(name, ""))
		Return 0
	endif
	string Ra,Qa,Sa,Ea,Wa,oldRa,oldQa,oldSa,oldEa,oldWa
	if (!stringmatch(name, foldername ))
		fullfoldername="::"+foldername
		RenameDataFolder $fullfoldername,$name
	endif
	wave/Z DSM_int//debugger fails if wave doesn't exist and /z is missing
	wave/Z M_DSM_int
	basename=name[1,30]
	if (!(waveexists(DSM_int)||waveexists(M_DSM_int)))//no DSM waves
		Ra="r"+name[1,30]
		Qa="q"+name[1,30]
		Sa="s"+name[1,30]
		Ea="e"+name[1,30]
		Wa="w"+name[1,30]
		foldername =ReplaceString("'", foldername, "")//takes out ' for liberal names
		oldRa="r"+foldername[1,30]//problem if no dummy letter in folder name
		oldQa="q"+foldername[1,30]
		oldSa="s"+foldername[1,30]
		oldEa="e"+foldername[1,30]	
		oldWa="w"+foldername[1,30]		
		wave/z w=$oldRa
		if (waveexists(w))
			rename $oldRa,$Ra
			rename $oldQa,$Qa
			rename $oldSa,$Sa
			wave/z w=$oldEa
			if (waveexists(w))
				rename $oldEa,$Ea
			endif
			wave/z w=$oldWa
			if (waveexists(w))
				rename $oldWa,$Wa
			endif
		endif	
	return 2
	endif
	if ((waveexists(DSM_int))||(waveexists(M_DSM_int)))
		killall()	
		if (waveexists(M_DSM_int))	
			Ra="r"+name[1,30]
			Qa="q"+name[1,30]
			Sa="s"+name[1,30]
			rename M_DSM_int,$Ra
			rename M_DSM_Qvec,$Qa
			rename M_DSM_Error,$Sa
			if (waveexists(DSM_int))	
				Ra="rDS_"+name[1,30]
				Qa="qDS_"+name[1,30]
				Sa="sDS_"+name[1,30]
				rename DSM_int,$Ra
				rename DSM_Qvec,$Qa
				rename DSM_Error,$Sa
			endif
		endif		
		if (waveexists(DSM_int)&!waveexists(M_DSM_int))	//DSM but no M_DSM
			Ra="r"+name[1,30]
			Qa="q"+name[1,30]
			Sa="s"+name[1,30]
			rename DSM_int,$Ra
			rename DSM_Qvec,$Qa
			rename DSM_Error,$Sa
		endif
	return 1	
	endif
	FixNamesAPS()
end

function FixNamesAPS()
	setdatafolder root:
	FindPathToTraceInGraph("Pick Trace")
	FixNamesAPS_local()
end

Function FixqrsNames()
	string Samplefolder
	Prompt SampleFolder, "Select  data folder for sample", popup, FindQRSfolders()
	doprompt "Plot Input Panel", SampleFolder	
	SetDataFolder SampleFolder			
	FixNamesAPS_local()
	//FixAnisonamesAPS_local()
	//FixqrsNames()
end

function/s FindQRSfolders()//must have all three waves with qrs naming convention
	string  result
	result=IR1_ReturnListQRSFolders(IN2G_FindFolderWithWaveTypes("root:", 10, "r*", 1),1)
	return result
	end  


function FixIlavskyName()
	execute "SetOperationFolder()"
	FixIlavsky_local()
end

function FixIlavsky_local()
	string new="",fullfoldername
	string foldername=getdatafolder (0)
	foldername =CleanupName(foldername, 0 )
	new=Getnamechanges(foldername)
	new =CleanupName(new, 0 )
	string name=new
	IF (stringmatch(name, ""))
		Return 0
	endif

	wave/Z UnifiedFitIntensity_0//debugger fails if wave doesn't exist and /z is missing
	string Ra,Qa,Sa,oldRa,oldQa,oldSa
	if (waveexists(UnifiedFitIntensity_0))
		Ra="r"+name+"_Fit"
		Qa="q"+name+"_Fit"
		oldRa="UnifiedFitIntensity_0"
		oldQa="UnifiedFitQvector_0"
		wave/z w=$oldRa
		if (waveexists(w))
			duplicate $oldRa,$Ra
			duplicate $oldQa,$Qa
		endif	
	return 2
	endif
	return 1
end

function GetUSAXSParameters(type)//assumes qrs format
		variable type
		prompt type, "Data Structure", popup,  "QRS;Indra"
		//prompt wavestoread, "Choose waves to read", popup, "DSM_Int;DSM_Int and M_DSM_Int"
		doprompt "Data Structure", type
		DoWindow /K parameters
		NewNotebook/F=1/N=parameters as "ParametersNotebook"
		notebook parameters margins={0,1,10000}
		string cols="Scan\tName\tUserSampleName\tDate\tBlankComment\tBlank\tTransmission\tSaThickness\tFWHM\tM_Corr\r"//\tBlankFWHM\r"
		notebook parameters, text=cols
		string text ="getparams("+num2str(type)+")"
		ScanAllFolders("root:", 4,text)
		SaveNotebook/M="Save Parameters notebook" /I/s=6 parameters as "Parameters"
end

Function ScanAllFolders(startDF, levels,functionName)//executes "function name" in all folders    // example: ScanAllFolders("root:", 2,"ReturnFolderName()")
        String startDF                  // startDF requires trailing colon.
        Variable levels		//set 1 for long type and 0 for short type return
        			//returns the list of folders with specCommand with "uascan" in it - may not work yet for sbuascan 
        String functionName                 
        String list = "", templist
        string dfSave
        dfSave = GetDataFolder(1)
  	if (!DataFolderExists(startDF))
  		return 1
  	endif  	
        SetDataFolder startDF
        templist = DataFolderDir(0)
	execute functionName
	NVAR v_flag=root:v_flag
	if (V_flag==2)
		Abort
	endif
	startDF=GetDataFolder(1)
        levels -= 1
        if (levels <= 0)
                return 1
        endif
        
        String subDF
        Variable index = 0
        do
                String temp
                temp = PossiblyQuoteName(GetIndexedObjName(startDF, 4, index))     	// Name of next data folder.
                if (strlen(temp) == 0)
                        break                                                                           			// No more data folders.
                endif
     	              subDF = startDF + temp + ":"
            		 ScanAllFolders(subDF, levels,functionName)       	// Recurse.
                index += 1
        while(1)
        
        SetDataFolder(dfSave)
        return 1
End

function/s getparams(type)
	variable type	
	string SampleFolder
	//Prompt SampleFolder, "Select  data folder for sample", popup,  IN2G_FindFolderWithWaveTypes("root:", 5, "r*", 1)	
	SampleFolder=replacestring("'",getdatafolder(0),"")
	string rwavename="DSM_Int"
	string r2wavename="M_DSM_Int"
	string r3wavename="USAXS_PD"//"PD_Intensity"
	if(type==1)
		rwavename="r"+samplefolder[1,30]
		r2wavename="r"+samplefolder[1,30]
		r3wavename="r"+samplefolder[1,30]
	endif
	SVAR ListOFASBParameters
	if((WaveExists($rwavename)||WaveExists($r2wavename)||WaveExists($r3wavename))&&(exists("ListOfASBParameters")==2))
		string thestring=note($r3wavename)
		string params="", cols=""
		//SVAR ListOfASBParameters
		params+=(StringByKey("SCAN_N",  thestring, "="))
		params+="\t"+rwavename
		params+="\t"+SampleFolder//(StringByKey("UserSampleName",  thestring, "="))
		params+="\t"+(StringByKey("DATE",  thestring, "="))
		if(WaveExists($rwavename)||WaveExists($r2wavename))
			if(WaveExists($rwavename))
				thestring=note($rwavename)
			else
				thestring=note($r2wavename)
			endif
			NVAR PeakWidth
			params+="\t"+(StringByKey("BlankComment",  thestring, "="))
			params+="\t"+(StringByKey("Blank",  ListOFASBParameters, "="))
			params+="\t"+(StringByKey("SampleTransmission",  thestring, "="))
			params+="\t"+(StringByKey("SampleThickness",  thestring, "="))
			params+="\t"+num2str(PeakWidth*3600)//(StringByKey("FWHM",  thestring, "="))
			//params+="\t"+(StringByKey("BlankWidthUsed",  ListOfASBParameters, "="))
	
			if (WaveExists($r2wavename))
				thestring=note($r2wavename)
				params+="\t"+(StringByKey("MSAXSCorrection",thestring, "="))
			endif
		endif
		params+="\r"
		notebook parameters,text=params
		//print params
		return params
	endif
	return "skip"
end




function qtimes10()
	string SampleFolder
	Prompt SampleFolder, "Select  data folder for sample", popup,  IN2G_FindFolderWithWaveTypes("root:", 5, "*", 1)
	doprompt "pick folder", Samplefolder
	
	SetDataFolder SampleFolder		
	string name=getdatafolder (0)
	IF (stringmatch(name, ""))
		Return 0
	endif
	string qwave
		
		qwave="q"+name[1,30]
		wave w=$qwave
		w*=10

	return 2
end

function/s getwavename(Ya)
	string ya
	Prompt Ya,"Pick Rwave",popup,WaveList("R*", ";", "")
	doprompt "Pick rwave", Ya
	return ya
end


Function killall()
	string list=WaveList("!*SM*", ";", "")
	print list
	variable items=itemsinlist(list,";")
	print num2str(items)
	variable i
	for(i=0;(i<items);i=i+1)	
		print stringfromlist (i,list)
		killwaves $(stringfromlist (i,list))							
	endfor								
end


